package gov.va.vinci.dart.json;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="request")
@XmlType(name="Request", propOrder={
		"requestId",
		"activityId",
		"workflowId",
		"trackingNumber",
		"submitted",
		"status",
		"initialReview",
		"finalReview",
		"readyForInitialReview",
		"editable",
		"amendment",
		"amendmentNarrative"
})
public class RequestDetailsView {

//review-project.js
	//trackingNumber
	//amendment details:  amendment, trackingNumber, amendmentNarrative
	//status -> data.workflowStatusList[0].status
	//initialReview
	//finalReview

//create-new-project.js
	//trackingNumber
	//amendment details:  amendment, trackingNumber, amendmentNarrative
	//status (currently not displayed in the UI) -> data.workflowStatusList[0].status
	//editable
	//submitted

//review-non-research-request.js
	//trackingNumber
	//amendment details:  amendment, trackingNumber, amendmentNarrative
	//status (currently not displayed in the UI, used with the submitted flag) -> data.workflowStatusList[0].status
	//initialReview
	//finalReview
	
//create-non-research-request.js
	//trackingNumber
	//amendment details:  amendment, trackingNumber, amendmentNarrative
	//editable
	
	
	private int requestId;
	private int activityId;
	private int workflowId = 0;
	private String trackingNumber;
	private String submitted;
	private String status;
	private boolean initialReview;
	private boolean finalReview;
	private boolean readyForInitialReview = false;
	private boolean readyForGroupReview = false;
	private boolean editable;
	private boolean amendment = false;
	private String amendmentNarrative;
	

	
	public int getRequestId() {
		return requestId;
	}

	public void setRequestId(int requestId) {
		this.requestId = requestId;
	}

	public String getTrackingNumber() {
		return trackingNumber;
	}

	public void setTrackingNumber(String trackingNumber) {
		this.trackingNumber = trackingNumber;
	}

	public String getSubmitted() {
		return submitted;
	}

	public void setSubmitted(String submitted) {
		this.submitted = submitted;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public int getActivityId() {
		return activityId;
	}

	public void setActivityId(int activityId) {
		this.activityId = activityId;
	}

	public int getWorkflowId() {
		return workflowId;
	}

	public void setWorkflowId(int workflowId) {
		this.workflowId = workflowId;
	}	
	
	public boolean isInitialReview() {
		return initialReview;
	}

	public void setInitialReview(boolean initialReview) {
		this.initialReview = initialReview;
	}

	public boolean isFinalReview() {
		return finalReview;
	}

	public void setFinalReview(boolean finalReview) {
		this.finalReview = finalReview;
	}

	public boolean isReadyForInitialReview() {
		return readyForInitialReview;
	}

	public void setReadyForInitialReview(boolean readyForInitialReview) {
		this.readyForInitialReview = readyForInitialReview;
	}

	public boolean isReadyForGroupReview() {
        return readyForGroupReview;
    }

    public void setReadyForGroupReview(boolean readyForGroupReview) {
        this.readyForGroupReview = readyForGroupReview;
    }

    public boolean isEditable() {
		return editable;
	}

	public void setEditable(boolean editable) {
		this.editable = editable;
	}

	public String getAmendmentNarrative() {
		return amendmentNarrative;
	}

	public void setAmendmentNarrative(String amendmentNarrative) {
		this.amendmentNarrative = amendmentNarrative;
	}
	
	public boolean isAmendment() {
		return amendment;
	}

	public void setAmendment(boolean amendment) {
		this.amendment = amendment;
	}

}
